#!/bin/sh

kernelRootPath=""
kernelTouchscreenPath=""
kernelI2CDriverPath=""
kernelSPIDriverPath=""

echo "Please enter the path (without a trailing /) to the root of a 2.6.x kernel source tree: "
read kernelRootPath

if [ ! -d $kernelRootPath ]; then
	echo "Path not found."
	exit 1
fi

kernelTouchscreenPath="${kernelRootPath}/drivers/input/touchscreen"

if [ ! -d $kernelTouchscreenPath ]; then
	echo "Invalid kernel root specified."
	exit 1
fi

kernelI2CDriverPath="${kernelTouchscreenPath}/ar1020-i2c.c"
kernelSPIDriverPath="${kernelTouchscreenPath}/ar1020-spi.c"

if [ -f $kernelI2CDriverPath ]; then
	echo "Kernel tree already updated."
	exit 1
fi

if [ -f $kernelSPIDriverPath ]; then
	echo "Kernel tree already updated."
	exit 1
fi

echo "Copying ar1020-i2c.c to ${kernelTouchscreenPath}"
cp ar1020-i2c.c $kernelI2CDriverPath

echo "Copying ar1020-spi.c to ${kernelTouchscreenPath}"
cp ar1020-spi.c $kernelSPIDriverPath

echo "Updating ${kernelTouchscreenPath}/Makefile"
echo "obj-\$(CONFIG_TOUCHSCREEN_AR1020_I2C)\t+= ar1020-i2c.o">> "${kernelTouchscreenPath}/Makefile"
echo "obj-\$(CONFIG_TOUCHSCREEN_AR1020_SPI)\t+= ar1020-spi.o">> "${kernelTouchscreenPath}/Makefile"



echo "Updating ${kernelTouchscreenPath}/Kconfig"
cat "${kernelTouchscreenPath}/Kconfig" | grep -v endif > "${kernelTouchscreenPath}/KconfigTemp"

echo "config TOUCHSCREEN_AR1020_I2C" >> "${kernelTouchscreenPath}/KconfigTemp"
echo "        tristate \"Microchip AR1020 I2C touchscreen\"" >> "${kernelTouchscreenPath}/KconfigTemp"
echo "        depends on I2C" >> "${kernelTouchscreenPath}/KconfigTemp"
echo "        help" >> "${kernelTouchscreenPath}/KconfigTemp"
echo "          Say Y here if you have a Microchip AR1020 I2C Controller and" >> "${kernelTouchscreenPath}/KconfigTemp"
echo "          want to enable support for the built-in touchscreen." >> "${kernelTouchscreenPath}/KconfigTemp"
echo "" >> "${kernelTouchscreenPath}/KconfigTemp"
echo "          To compile this driver as a module, choose M here: the" >> "${kernelTouchscreenPath}/KconfigTemp"
echo "          module will be called ar1020-i2c." >> "${kernelTouchscreenPath}/KconfigTemp"
echo "" >> "${kernelTouchscreenPath}/KconfigTemp"
echo "config TOUCHSCREEN_AR1020_SPI" >> "${kernelTouchscreenPath}/KconfigTemp"
echo "        tristate \"Microchip AR1020 SPI touchscreen\"" >> "${kernelTouchscreenPath}/KconfigTemp"
echo "        depends on SPI_MASTER" >> "${kernelTouchscreenPath}/KconfigTemp"
echo "        help" >> "${kernelTouchscreenPath}/KconfigTemp"
echo "          Say Y here if you have a Microchip AR1020 SPI Controller and" >> "${kernelTouchscreenPath}/KconfigTemp"
echo "          want to enable support for the built-in touchscreen." >> "${kernelTouchscreenPath}/KconfigTemp"
echo "" >> "${kernelTouchscreenPath}/KconfigTemp"
echo "          To compile this driver as a module, choose M here: the" >> "${kernelTouchscreenPath}/KconfigTemp"
echo "          module will be called ar1020-spi." >> "${kernelTouchscreenPath}/KconfigTemp"
echo "" >> "${kernelTouchscreenPath}/KconfigTemp"

echo "endif" >> "${kernelTouchscreenPath}/KconfigTemp"

mv -v "${kernelTouchscreenPath}/KconfigTemp" "${kernelTouchscreenPath}/Kconfig"

echo "Kernel tree successfully updated."
echo
echo "To compile AR1020 I2C or SPI driver, configure the kernel to include one of these drivers."
echo "For more information, please see documentation."

