#!/bin/sh

if [ ! -f tslib.tar.gz ]; then
	echo "tslib.tar.gz file not found."
	echo
	echo "Please download the tslib source code from"
	echo "https://github.com/kergoth/tslib or"
	echo "the current Linux distributions source"
	echo "repository."
	echo
	echo "After getting the source bundle (with tar.gz extension),"
	echo "rename the file to tslib.tar.gz and place inside"
	echo "this directory."
else
	echo "Extracting files"
	tar zxvf tslib.tar.gz

	# set PREFIX and HOST variables here for convenience

	# All the binary files will be this location after the script has completed execution.
	export PREFIX=/usr/local/tslib

	# configure script requires the "--host" parameter for cross-compiled application
	export HOST=i486-linux-gnu

	# These next options are set only when setting up a cross compiler environment for the configure script.
	# The configure script automatically reads these environmental variables.
	# Please set these according the cross compile untilities used within your cross-compile toolchain.
	# Normally, only the prefix is different.  For example, if the prefix is arm-linux, then the lines would be
	#set as follows (minus the comments)
#	export CC=arm-linux-gcc
#	export CXX=arm-linux-g++
#	export AR=arm-linux-ar
#	export RANLIB=arm-linux-ranlib

	# add this export to correct a linker error found most common during cross-compilation (related to autotools)
        export ac_cv_func_malloc_0_nonnull=yes

	cp input-raw.c.patch ./tslib-1.0/plugins -v
	cp ts_calibrate.c.patch ./tslib-1.0/tests -v
        echo "Patching input-raw.c"
	cd ./tslib-1.0/plugins
	patch -p0 < input-raw.c.patch
	# If there are errors returned from ts_calibrate, then the compiler
	# is likely an older version.  If this is the case, please
	# comment out the next three lines.
        echo "Patching ts_calibrate.c"
	cd ../tests
	patch -p0 < ts_calibrate.c.patch
	cd ..

	libtoolize
	./autogen.sh

	# Running these two lines again since often not all dependent files are created from the first run.
	libtoolize
	./autogen.sh

	./configure --prefix=${PREFIX} --host=${HOST}
	make
	make install
	cd ..
	echo "Installation complete."
	echo
	echo "Next environmental variables will need to be setup in order to"
	echo "run 'ts_calibrate' and 'ts_test' tslib utilities."
	echo
	echo "For example if evdev path is at /dev/input/event5,"
	echo "the minimum environmental variables will need to be set"
	echo "by using the following commands."
	echo
	echo "export TSLIB_TSDEVICE=/dev/input/event5"
	echo "export TSLIB_PLUGINDIR=/usr/local/lib/ts"
	echo

fi
